<?php

session_start(); // شروع session

// اگر کاربر لاگین نکرده باشد
if(!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true){
    header("Location: ../login.php"); // ریدایرکت به صفحه لاگین
    exit;
}


require "../config/db.php";

if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $name = $_POST['name'];
    $phone = $_POST['phone'];
    $service_type = $_POST['service_type'];
    $level = $_POST['level'];
    $status = $_POST['status'];

    $stmt = $conn->prepare("INSERT INTO customers (name, phone, service_type, level, status) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("sssss", $name, $phone, $service_type, $level, $status);
    $stmt->execute();
    header("Location: list.php");
}
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>افزودن مشتری</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen flex items-center justify-center">

<div class="bg-white p-8 rounded-3xl shadow-lg w-full max-w-lg">
    <h2 class="text-3xl font-bold mb-6 text-gray-800">افزودن مشتری جدید</h2>

    <form method="POST" class="space-y-5">
        <input type="text" name="name" placeholder="نام مشتری" required 
               class="w-full p-3 rounded-xl border border-gray-300 focus:ring-2 focus:ring-indigo-500 outline-none">
        
        <input type="text" name="phone" placeholder="شماره تماس" required
               class="w-full p-3 rounded-xl border border-gray-300 focus:ring-2 focus:ring-indigo-500 outline-none">

        <input type="text" name="service_type" placeholder="نوع خدمات" required
               class="w-full p-3 rounded-xl border border-gray-300 focus:ring-2 focus:ring-indigo-500 outline-none">

        <select name="level" required class="w-full p-3 rounded-xl border border-gray-300 focus:ring-2 focus:ring-indigo-500 outline-none">
            <option value="عادی">عادی</option>
            <option value="VIP">VIP</option>
        </select>

        <select name="status" required class="w-full p-3 rounded-xl border border-gray-300 focus:ring-2 focus:ring-indigo-500 outline-none">
            <option value="فعال">فعال</option>
            <option value="غیرفعال">غیرفعال</option>
        </select>

        <button type="submit" class="w-full py-3 bg-gradient-to-r from-indigo-500 to-indigo-700 text-white rounded-xl shadow hover:scale-105 transition transform font-semibold">
            ذخیره مشتری
        </button>
    </form>
</div>
</body>
</html>
