<?php
require "../config/db.php";
session_start(); // شروع session

// اگر کاربر لاگین نکرده باشد
if(!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true){
    header("Location: ../login.php"); // ریدایرکت به صفحه لاگین
    exit;
}

$id = $_GET['id'];
$customerData = $conn->query("SELECT * FROM customers WHERE id=$id")->fetch_assoc();

if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $name = $_POST['name'];
    $phone = $_POST['phone'];
    $service_type = $_POST['service_type'];
    $level = $_POST['level'];
    $status = $_POST['status'];

    $stmt = $conn->prepare("UPDATE customers SET name=?, phone=?, service_type=?, level=?, status=? WHERE id=?");
    $stmt->bind_param("sssssi", $name, $phone, $service_type, $level, $status, $id);
    $stmt->execute();
    header("Location: list.php");
}
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>ویرایش مشتری</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen flex items-center justify-center">

<div class="bg-white p-8 rounded-3xl shadow-lg w-full max-w-lg">
    <h2 class="text-3xl font-bold mb-6 text-gray-800">ویرایش مشتری</h2>

    <form method="POST" class="space-y-5">
        <input type="text" name="name" value="<?= $customerData['name'] ?>" required 
               class="w-full p-3 rounded-xl border border-gray-300 focus:ring-2 focus:ring-indigo-500 outline-none">
        
        <input type="text" name="phone" value="<?= $customerData['phone'] ?>" required
               class="w-full p-3 rounded-xl border border-gray-300 focus:ring-2 focus:ring-indigo-500 outline-none">

        <input type="text" name="service_type" value="<?= $customerData['service_type'] ?>" required
               class="w-full p-3 rounded-xl border border-gray-300 focus:ring-2 focus:ring-indigo-500 outline-none">

        <select name="level" required class="w-full p-3 rounded-xl border border-gray-300 focus:ring-2 focus:ring-indigo-500 outline-none">
            <option value="عادی" <?= $customerData['level']=="عادی"?'selected':'' ?>>عادی</option>
            <option value="VIP" <?= $customerData['level']=="VIP"?'selected':'' ?>>VIP</option>
        </select>

        <select name="status" required class="w-full p-3 rounded-xl border border-gray-300 focus:ring-2 focus:ring-indigo-500 outline-none">
            <option value="فعال" <?= $customerData['status']=="فعال"?'selected':'' ?>>فعال</option>
            <option value="غیرفعال" <?= $customerData['status']=="غیرفعال"?'selected':'' ?>>غیرفعال</option>
        </select>

        <button type="submit" class="w-full py-3 bg-gradient-to-r from-blue-500 to-blue-700 text-white rounded-xl shadow hover:scale-105 transition transform font-semibold">
            ذخیره تغییرات
        </button>
    </form>
</div>
</body>
</html>
