<?php
require "../config/db.php";
session_start(); // شروع session

// اگر کاربر لاگین نکرده باشد
if(!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true){
    header("Location: ../login.php"); // ریدایرکت به صفحه لاگین
    exit;
}

$customers = $conn->query("SELECT * FROM customers ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>لیست مشتری‌ها</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen p-10">

<h2 class="text-3xl font-bold mb-6 text-gray-800">مشتریان</h2>

<div class="flex flex-wrap justify-between mb-6 gap-3">
    <div class="flex gap-3 flex-wrap">
        <a href="add.php" class="px-6 py-3 bg-gradient-to-r from-indigo-500 to-indigo-700 text-white rounded-xl shadow hover:scale-105 transition transform">
            + افزودن مشتری
        </a>
        <button onclick="copyAllPhones()" class="px-6 py-3 bg-gradient-to-r from-green-400 to-green-600 text-white rounded-xl shadow hover:scale-105 transition transform">
            📋 کپی تمام شماره‌ها
        </button>
    </div>
    <a href="../index.php" class="px-6 py-3 bg-gray-800 text-white rounded-xl shadow hover:scale-105 transition transform">
        ← بازگشت به داشبورد
    </a>
</div>

<div class="mb-4 flex gap-4 flex-wrap">
    <input type="text" id="searchInput" placeholder="جستجو نام یا شماره..." 
           class="p-3 rounded-xl border border-gray-300 focus:outline-none focus:ring-2 focus:ring-indigo-500 flex-grow">
    <select id="filterLevel" class="p-3 rounded-xl border border-gray-300 focus:outline-none focus:ring-2 focus:ring-indigo-500">
        <option value="">همه سطح‌ها</option>
        <option value="عادی">عادی</option>
        <option value="VIP">VIP</option>
    </select>
    <select id="filterStatus" class="p-3 rounded-xl border border-gray-300 focus:outline-none focus:ring-2 focus:ring-indigo-500">
        <option value="">همه وضعیت‌ها</option>
        <option value="فعال">فعال</option>
        <option value="غیرفعال">غیرفعال</option>
    </select>
</div>

<div class="bg-white rounded-3xl shadow-lg p-6 overflow-x-auto">
    <table class="w-full table-auto text-right text-gray-700" id="customersTable">
        <thead>
            <tr class="bg-gray-200 rounded-xl">
                <th class="p-3">شناسه</th>
                <th class="p-3">نام مشتری</th>
                <th class="p-3">شماره تماس</th>
                <th class="p-3">نوع خدمات</th>
                <th class="p-3">سطح</th>
                <th class="p-3">وضعیت</th>
                <th class="p-3">عملیات</th>
            </tr>
        </thead>
        <tbody>
            <?php while($row = $customers->fetch_assoc()): ?>
            <tr class="border-b hover:bg-gray-50 transition cursor-pointer">
                <td class="p-3"><?= $row["id"] ?></td>
                <td class="p-3"><?= $row["name"] ?></td>
                <td class="p-3 flex items-center gap-2">
                    <span id="phone-<?= $row['id'] ?>"><?= $row["phone"] ?></span>
                    <button onclick="copyPhone('phone-<?= $row['id'] ?>')" 
                            class="px-2 py-1 bg-blue-500 text-white rounded hover:bg-blue-600 transition text-sm">
                        📋
                    </button>
                </td>
                <td class="p-3"><?= $row["service_type"] ?></td>
                <td class="p-3">
                    <?php if($row["level"]=="VIP"): ?>
                        <span class="px-3 py-1 bg-yellow-400 text-yellow-900 rounded-full text-sm font-semibold">VIP</span>
                    <?php else: ?>
                        <span class="px-3 py-1 bg-gray-300 text-gray-900 rounded-full text-sm">عادی</span>
                    <?php endif; ?>
                </td>
                <td class="p-3">
                    <?php if($row["status"]=="فعال"): ?>
                        <span class="px-3 py-1 bg-green-200 text-green-800 rounded-full text-sm font-medium">فعال</span>
                    <?php else: ?>
                        <span class="px-3 py-1 bg-red-200 text-red-800 rounded-full text-sm font-medium">غیرفعال</span>
                    <?php endif; ?>
                </td>
                <td class="p-3 flex gap-2">
                    <a href="edit.php?id=<?= $row['id'] ?>" class="px-3 py-1 bg-blue-500 text-white rounded hover:bg-blue-600 transition">ویرایش</a>
                    <a href="delete.php?id=<?= $row['id'] ?>" 
                       onclick="return confirm('آیا مطمئن هستید می‌خواهید حذف کنید؟')"
                       class="px-3 py-1 bg-red-500 text-white rounded hover:bg-red-600 transition">حذف</a>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>

<script>
// کپی شماره تماس تکی
function copyPhone(id){
    const phone = document.getElementById(id).innerText;
    navigator.clipboard.writeText(phone).then(() => alert("شماره کپی شد: " + phone));
}

// کپی تمام شماره‌ها
function copyAllPhones(){
    const phones = Array.from(document.querySelectorAll("span[id^='phone-']")).map(span => span.innerText).join("\n");
    navigator.clipboard.writeText(phones).then(() => alert("تمام شماره‌ها کپی شد!"));
}

// جستجوی زنده و فیلترها
function filterTable(){
    const search = document.getElementById("searchInput").value.toLowerCase();
    const levelFilter = document.getElementById("filterLevel").value;
    const statusFilter = document.getElementById("filterStatus").value;

    const rows = document.querySelectorAll("#customersTable tbody tr");
    rows.forEach(row => {
        const text = row.innerText.toLowerCase();
        const level = row.cells[4].innerText;
        const status = row.cells[5].innerText;

        const matchesSearch = text.includes(search);
        const matchesLevel = levelFilter === "" || level.includes(levelFilter);
        const matchesStatus = statusFilter === "" || status.includes(statusFilter);

        row.style.display = (matchesSearch && matchesLevel && matchesStatus) ? "" : "none";
    });
}

document.getElementById("searchInput").addEventListener("input", filterTable);
document.getElementById("filterLevel").addEventListener("change", filterTable);
document.getElementById("filterStatus").addEventListener("change", filterTable);
</script>

</body>
</html>
