<?php
/***********************************************
 *  اتصال به دیتابیس 
 ***********************************************/
$host = "localhost";
$user = "root";
$pass = "";
$dbname = "crm_system";

// اتصال
$conn = new mysqli($host, $user, $pass);

// خطا چک کردن اتصال
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

/***********************************************
 *  ساخت دیتابیس اگر وجود ندارد
 ***********************************************/
$conn->query("CREATE DATABASE IF NOT EXISTS $dbname CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;");
$conn->select_db($dbname);

/***********************************************
 *  جدول مشتری‌ها
 ***********************************************/
$customers_table = "
CREATE TABLE IF NOT EXISTS customers (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    phone VARCHAR(20) NOT NULL UNIQUE,
    service_type VARCHAR(100) NOT NULL,
    level ENUM('عادی','VIP') DEFAULT 'عادی',
    status ENUM('فعال','غیرفعال') DEFAULT 'فعال',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB;
";

$conn->query($customers_table);


/***********************************************
 *  جدول تارگت‌ها
 ***********************************************/
$targets_table = "
CREATE TABLE IF NOT EXISTS targets (
    id INT AUTO_INCREMENT PRIMARY KEY,
    target_name VARCHAR(100) NULL,
    phone VARCHAR(20) NOT NULL,
    work_field VARCHAR(100) NOT NULL,
    address VARCHAR(255) NOT NULL,
    description TEXT NULL,
    status ENUM('فعال','غیرفعال') DEFAULT 'فعال',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB;
";

$conn->query($targets_table);


/***********************************************
 *  جدول یادداشت‌ها
 ***********************************************/
$notes_table = "
CREATE TABLE IF NOT EXISTS notes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    customer_id INT NOT NULL,
    note TEXT NOT NULL,
    status ENUM('فعال','غیرفعال') DEFAULT 'فعال',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (customer_id) REFERENCES customers(id) ON DELETE CASCADE
) ENGINE=InnoDB;
";

$conn->query($notes_table);

echo "<h2>تمام جدول‌ها با موفقیت ساخته شدند ✔</h2>";
?>
