<?php
require "config/db.php";

session_start(); // شروع session

// اگر کاربر لاگین نکرده باشد
if(!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true){
    header("Location: login.php"); // ریدایرکت به صفحه لاگین
    exit;
}

// آمار کلی
$totalCustomers = $conn->query("SELECT COUNT(*) as total FROM customers")->fetch_assoc()['total'];
$totalTargets = $conn->query("SELECT COUNT(*) as total FROM targets")->fetch_assoc()['total'];
$totalNotes = $conn->query("SELECT COUNT(*) as total FROM notes")->fetch_assoc()['total'];

// آخرین ثبت‌ها
$lastCustomer = $conn->query("SELECT * FROM customers ORDER BY id DESC LIMIT 1")->fetch_assoc();
$lastTarget = $conn->query("SELECT * FROM targets ORDER BY id DESC LIMIT 1")->fetch_assoc();
$lastNotes = $conn->query("SELECT * FROM notes ORDER BY id DESC LIMIT 5");

// داده‌های اضافی برای چارت
$customerLevels = $conn->query("SELECT level, COUNT(*) as count FROM customers GROUP BY level");
$targetStatus = $conn->query("SELECT status, COUNT(*) as count FROM targets GROUP BY status");
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>داشبورد حرفه‌ای CRM | نماگر</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        * {
            font-family: 'Vazirmatn', sans-serif;
        }
        
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #e4edf5 100%);
            min-height: 100vh;
            overflow-x: hidden;
        }
        
        /* انیمیشن‌های سفارشی */
        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        @keyframes pulse-glow {
            0%, 100% { box-shadow: 0 0 10px rgba(99, 102, 241, 0.3); }
            50% { box-shadow: 0 0 20px rgba(99, 102, 241, 0.6); }
        }
        
        @keyframes shimmer {
            0% { background-position: -200% center; }
            100% { background-position: 200% center; }
        }
        
        .fade-in-up {
            animation: fadeInUp 0.8s ease-out;
        }
        
        .pulse-glow {
            animation: pulse-glow 2s infinite;
        }
        
        .shimmer-bg {
            background: linear-gradient(90deg, rgba(255,255,255,0) 0%, rgba(255,255,255,0.8) 50%, rgba(255,255,255,0) 100%);
            background-size: 200% auto;
            animation: shimmer 3s infinite linear;
        }
        
        /* استایل‌های سفارشی برای کارت‌ها */
        .glass-card {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.3);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.08);
        }
        
        .neumorphic {
            border-radius: 20px;
            background: linear-gradient(145deg, #ffffff, #e6e9ef);
            box-shadow: 10px 10px 20px #d9dbe2, -10px -10px 20px #ffffff;
        }
        
        .stat-card {
            position: relative;
            overflow: hidden;
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            border-radius: 24px;
        }
        
        .stat-card:hover {
            transform: translateY(-10px);
        }
        
        .gradient-text {
            background: linear-gradient(90deg, #6366f1, #8b5cf6);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        /* استایل‌های اسکرول بار سفارشی */
        .custom-scrollbar::-webkit-scrollbar {
            width: 6px;
        }
        
        .custom-scrollbar::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 10px;
        }
        
        .custom-scrollbar::-webkit-scrollbar-thumb {
            background: linear-gradient(180deg, #6366f1, #8b5cf6);
            border-radius: 10px;
        }
        
        /* دکمه‌های مدرن */
        .modern-btn {
            position: relative;
            overflow: hidden;
            transition: all 0.3s ease;
        }
        
        .modern-btn::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 5px;
            height: 5px;
            background: rgba(255, 255, 255, 0.5);
            opacity: 0;
            border-radius: 100%;
            transform: scale(1, 1) translate(-50%);
            transform-origin: 50% 50%;
        }
        
        .modern-btn:focus:not(:active)::after {
            animation: ripple 1s ease-out;
        }
        
        @keyframes ripple {
            0% { transform: scale(0, 0); opacity: 0.5; }
            100% { transform: scale(40, 40); opacity: 0; }
        }
        
        /* بارگذاری اسکلت */
        .skeleton {
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: shimmer 1.5s infinite linear;
            border-radius: 8px;
        }
    </style>
</head>
<body class="min-h-screen p-4 md:p-8">
    <!-- نوار ادمین در بالای صفحه -->
<div class="w-full flex justify-center mb-6 md:mb-8 pt-4">
    <div class="relative group w-full max-w-4xl mx-4">
        <div class="glass-card rounded-2xl p-4 shadow-xl border border-white/50">
            <div class="flex flex-col md:flex-row items-center justify-between gap-4">
                <!-- اطلاعات ادمین -->
                <div class="flex items-center gap-4">
                    <div class="w-14 h-14 bg-gradient-to-r from-indigo-500 via-purple-500 to-pink-500 rounded-2xl flex items-center justify-center shadow-lg">
                        <i class="fas fa-user-shield text-white text-2xl"></i>
                    </div>
                    <div class="text-right">
                        <h3 class="font-bold text-gray-900 text-lg">پنل مدیریت سیستم</h3>
                        <p class="text-gray-600 text-sm">دسترسی سطح ادمین | آخرین ورود: امروز</p>
                    </div>
                </div>
                
                <!-- منوی ادمین -->
                <div class="flex items-center gap-3">
                    <!-- دکمه‌های سریع -->
                    <div class="flex flex-wrap gap-2">
                        <a href="admin/dashboard.php" class="modern-btn px-4 py-2 bg-indigo-50 text-indigo-700 rounded-xl hover:bg-indigo-100 transition flex items-center gap-2">
                            <i class="fas fa-tachometer-alt"></i>
                            <span class="hidden sm:inline">داشبورد</span>
                        </a>
                        
                        <a href="admin/users.php" class="modern-btn px-4 py-2 bg-blue-50 text-blue-700 rounded-xl hover:bg-blue-100 transition flex items-center gap-2">
                            <i class="fas fa-users-cog"></i>
                            <span class="hidden sm:inline">کاربران</span>
                        </a>
                        
                        <a href="admin/settings.php" class="modern-btn px-4 py-2 bg-green-50 text-green-700 rounded-xl hover:bg-green-100 transition flex items-center gap-2">
                            <i class="fas fa-cogs"></i>
                            <span class="hidden sm:inline">تنظیمات</span>
                        </a>
                    </div>
                    
                    <!-- دکمه خروج -->
                    <div class="relative group/logout">
                        <form action="logout.php" method="POST">
                            <a href="logout.php"><button type="submit" name="logout" 
                                class="modern-btn flex items-center gap-3 px-5 py-3 bg-gradient-to-r from-red-500 to-red-600 text-white rounded-xl hover:shadow-xl hover:from-red-600 hover:to-red-700 transition-all group-hover/logout:scale-105">
                                <i class="fas fa-sign-out-alt"></i>
                                <span class="font-bold">خروج</span>
                            </button></a>
                        </form>
                        
                        <!-- توضیح ابزار هنگام هاور -->
                        <div class="absolute bottom-full left-1/2 transform -translate-x-1/2 mb-2 px-3 py-2 bg-gray-900 text-white text-sm rounded-lg opacity-0 invisible group-hover/logout:opacity-100 group-hover/logout:visible transition-all duration-300 whitespace-nowrap">
                            خروج از حساب کاربری
                            <div class="absolute top-full left-1/2 transform -translate-x-1/2 w-2 h-2 bg-gray-900 rotate-45"></div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- منوی کشویی جزئیات (اختیاری) -->
            <div class="mt-4 pt-4 border-t border-gray-200 hidden group-hover:block">
                <div class="flex flex-wrap gap-4 justify-center">
                    <a href="admin/backup.php" class="flex items-center gap-2 text-gray-700 hover:text-indigo-600 transition">
                        <i class="fas fa-database text-purple-500"></i>
                        <span>پشتیبان‌گیری</span>
                    </a>
                    <a href="admin/logs.php" class="flex items-center gap-2 text-gray-700 hover:text-indigo-600 transition">
                        <i class="fas fa-history text-amber-500"></i>
                        <span>لاگ سیستم</span>
                    </a>
                    <a href="admin/reports.php" class="flex items-center gap-2 text-gray-700 hover:text-indigo-600 transition">
                        <i class="fas fa-chart-bar text-green-500"></i>
                        <span>گزارش‌ها</span>
                    </a>
                    <a href="admin/notifications.php" class="flex items-center gap-2 text-gray-700 hover:text-indigo-600 transition">
                        <i class="fas fa-bell text-red-500"></i>
                        <span>اعلان‌ها</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
    <!-- هدر با اطلاعات زمانی -->
    <header class="mb-8 md:mb-12 fade-in-up">
        <div class="flex flex-col md:flex-row justify-between items-start md:items-center gap-6">
            <div>
                <h1 class="text-3xl md:text-4xl font-bold text-gray-900 mb-2 flex items-center gap-3">
                    <span class="gradient-text">داشبورد CRM</span>
                    <span class="text-sm px-3 py-1 bg-gradient-to-r from-indigo-100 to-purple-100 text-indigo-600 rounded-full">نسخه حرفه‌ای</span>
                </h1>
                <p class="text-gray-600">مدیریت هوشمند مشتریان، اهداف و یادداشت‌ها</p>
            </div>
            
            <div class="flex flex-col items-start md:items-end">
                <div class="flex items-center gap-3 mb-2">
                    <div class="w-3 h-3 bg-green-500 rounded-full animate-pulse"></div>
                    <span class="text-gray-700 font-medium" id="connectionStatus">سیستم آنلاین</span>
                </div>
                <div class="glass-card rounded-2xl px-5 py-3 shadow-lg">
                    <div class="flex flex-col md:flex-row items-center gap-3 md:gap-5">
                        <div class="text-center md:text-right">
                            <div class="text-2xl md:text-3xl font-bold text-gray-900" id="time">--:--:--</div>
                            <div class="text-gray-600 text-sm" id="date">--- / -- / --</div>
                        </div>
                        <div class="hidden md:block w-px h-10 bg-gradient-to-b from-transparent via-gray-300 to-transparent"></div>
                        <div class="flex items-center gap-2">
                            <i class="fas fa-calendar-alt text-indigo-500 text-lg"></i>
                            <div>
                                <div class="text-gray-900 font-semibold" id="dayName">---</div>
                                <div class="text-gray-600 text-sm" id="persianDate">---</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- کارت‌های آماری -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-8 fade-in-up" style="animation-delay: 0.1s">
        <!-- کارت مشتریان -->
        <a href="customers/list.php" class="stat-card group">
            <div class="bg-gradient-to-br from-indigo-500 via-indigo-600 to-purple-700 text-white p-6 rounded-2xl h-full relative overflow-hidden">
                <div class="absolute top-0 right-0 w-32 h-32 -mt-8 -mr-8 bg-white/10 rounded-full"></div>
                <div class="absolute bottom-0 left-0 w-20 h-20 -mb-6 -ml-6 bg-white/10 rounded-full"></div>
                
                <div class="relative z-10">
                    <div class="flex justify-between items-start mb-4">
                        <div>
                            <h3 class="text-xl font-bold">مشتریان</h3>
                            <p class="text-indigo-100 opacity-90 mt-1">تعداد کل مشتری‌های ثبت شده</p>
                        </div>
                        <div class="bg-white/20 p-3 rounded-xl">
                            <i class="fas fa-users text-2xl"></i>
                        </div>
                    </div>
                    
                    <div class="mt-6 flex items-end justify-between">
                        <div class="text-5xl font-bold"><?php echo $totalCustomers; ?></div>
                        <div class="flex items-center bg-white/20 px-3 py-1 rounded-full">
                            <i class="fas fa-arrow-up text-xs ml-1"></i>
                            <span class="text-sm">امروز</span>
                        </div>
                    </div>
                    
                    <div class="mt-4 pt-4 border-t border-white/20 flex items-center justify-between">
                        <span class="text-sm">آخرین ثبت: <?php echo $lastCustomer ? $lastCustomer['name'] : 'ندارد'; ?></span>
                        <div class="text-sm opacity-80 group-hover:translate-x-1 transition-transform">
                            مشاهده <i class="fas fa-arrow-left"></i>
                        </div>
                    </div>
                </div>
            </div>
        </a>

        <!-- کارت تارگت‌ها -->
        <a href="targets/list.php" class="stat-card group">
            <div class="bg-gradient-to-br from-green-500 via-green-600 to-emerald-700 text-white p-6 rounded-2xl h-full relative overflow-hidden">
                <div class="absolute top-0 right-0 w-32 h-32 -mt-8 -mr-8 bg-white/10 rounded-full"></div>
                <div class="absolute bottom-0 left-0 w-20 h-20 -mb-6 -ml-6 bg-white/10 rounded-full"></div>
                
                <div class="relative z-10">
                    <div class="flex justify-between items-start mb-4">
                        <div>
                            <h3 class="text-xl font-bold">تارگت‌ها</h3>
                            <p class="text-green-100 opacity-90 mt-1">اهداف و مخاطبین هدف</p>
                        </div>
                        <div class="bg-white/20 p-3 rounded-xl">
                            <i class="fas fa-bullseye text-2xl"></i>
                        </div>
                    </div>
                    
                    <div class="mt-6 flex items-end justify-between">
                        <div class="text-5xl font-bold"><?php echo $totalTargets; ?></div>
                        <div class="flex items-center bg-white/20 px-3 py-1 rounded-full">
                            <i class="fas fa-chart-line text-xs ml-1"></i>
                            <span class="text-sm">فعال</span>
                        </div>
                    </div>
                    
                    <div class="mt-4 pt-4 border-t border-white/20 flex items-center justify-between">
                        <span class="text-sm">آخرین ثبت: <?php echo $lastTarget ? ($lastTarget['target_name'] ?: '-') : 'ندارد'; ?></span>
                        <div class="text-sm opacity-80 group-hover:translate-x-1 transition-transform">
                            مشاهده <i class="fas fa-arrow-left"></i>
                        </div>
                    </div>
                </div>
            </div>
        </a>

        <!-- کارت یادداشت‌ها -->
        <a href="notes/list.php" class="stat-card group">
            <div class="bg-gradient-to-br from-amber-500 via-orange-500 to-yellow-600 text-white p-6 rounded-2xl h-full relative overflow-hidden">
                <div class="absolute top-0 right-0 w-32 h-32 -mt-8 -mr-8 bg-white/10 rounded-full"></div>
                <div class="absolute bottom-0 left-0 w-20 h-20 -mb-6 -ml-6 bg-white/10 rounded-full"></div>
                
                <div class="relative z-10">
                    <div class="flex justify-between items-start mb-4">
                        <div>
                            <h3 class="text-xl font-bold">یادداشت‌ها</h3>
                            <p class="text-amber-100 opacity-90 mt-1">یادداشت‌ها و یادآوری‌ها</p>
                        </div>
                        <div class="bg-white/20 p-3 rounded-xl">
                            <i class="fas fa-sticky-note text-2xl"></i>
                        </div>
                    </div>
                    
                    <div class="mt-6 flex items-end justify-between">
                        <div class="text-5xl font-bold"><?php echo $totalNotes; ?></div>
                        <div class="flex items-center bg-white/20 px-3 py-1 rounded-full">
                            <i class="fas fa-clock text-xs ml-1"></i>
                            <span class="text-sm">آخرین 5</span>
                        </div>
                    </div>
                    
                    <div class="mt-4 pt-4 border-t border-white/20 flex items-center justify-between">
                        <span class="text-sm"><?php echo $totalNotes; ?> یادداشت ثبت شده</span>
                        <div class="text-sm opacity-80 group-hover:translate-x-1 transition-transform">
                            مشاهده <i class="fas fa-arrow-left"></i>
                        </div>
                    </div>
                </div>
            </div>
        </a>
    </div>

    <!-- بخش اصلی با جزئیات -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-8 fade-in-up" style="animation-delay: 0.2s">
        <!-- آخرین مشتری -->
        <div class="glass-card rounded-2xl p-6 lg:col-span-2">
            <div class="flex justify-between items-center mb-6">
                <h2 class="text-xl font-bold text-gray-900 flex items-center gap-2">
                    <i class="fas fa-user-circle text-indigo-500"></i>
                    آخرین مشتری ثبت شده
                </h2>
                <div class="flex gap-2">
                    <button class="modern-btn px-4 py-2 bg-indigo-50 text-indigo-600 rounded-xl hover:bg-indigo-100 transition-all" onclick="refreshData('customers')">
                        <i class="fas fa-sync-alt"></i>
                    </button>
                    <a href="customers/add.php" class="modern-btn px-4 py-2 bg-gradient-to-r from-indigo-500 to-indigo-700 text-white rounded-xl hover:shadow-lg transition-all">
                        <i class="fas fa-plus ml-1"></i> جدید
                    </a>
                </div>
            </div>
            
            <?php if($lastCustomer): ?>
            <div class="neumorphic p-5 rounded-xl">
                <div class="flex flex-col md:flex-row gap-6">
                    <div class="flex-1">
                        <div class="flex items-center gap-3 mb-4">
                            <div class="w-16 h-16 bg-gradient-to-r from-indigo-400 to-purple-500 rounded-xl flex items-center justify-center text-white text-2xl">
                                <?php echo substr($lastCustomer['name'], 0, 1); ?>
                            </div>
                            <div>
                                <h3 class="text-xl font-bold text-gray-900"><?php echo $lastCustomer['name']; ?></h3>
                                <p class="text-gray-600"><?php echo $lastCustomer['phone']; ?></p>
                            </div>
                        </div>
                        
                        <div class="grid grid-cols-2 gap-4 mt-6">
                            <div>
                                <p class="text-gray-500 text-sm">سطح مشتری</p>
                                <div class="mt-1">
                                    <span class="px-3 py-1 rounded-full text-sm font-semibold <?php echo $lastCustomer['level']=='VIP'?'bg-gradient-to-r from-yellow-100 to-amber-100 text-yellow-800':'bg-gray-100 text-gray-800'; ?>">
                                        <?php echo $lastCustomer['level']; ?>
                                        <?php if($lastCustomer['level']=='VIP'): ?>
                                            <i class="fas fa-crown text-xs mr-1"></i>
                                        <?php endif; ?>
                                    </span>
                                </div>
                            </div>
                            <div>
                                <p class="text-gray-500 text-sm">وضعیت</p>
                                <div class="mt-1">
                                    <?php 
                                        $statusColor = 'gray';
                                        if($lastCustomer['status'] == 'فعال') $statusColor = 'green';
                                        if($lastCustomer['status'] == 'معلق') $statusColor = 'yellow';
                                        if($lastCustomer['status'] == 'لغو شده') $statusColor = 'red';
                                    ?>
                                    <span class="px-3 py-1 rounded-full text-sm font-semibold bg-<?php echo $statusColor; ?>-100 text-<?php echo $statusColor; ?>-800">
                                        <?php echo $lastCustomer['status']; ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="md:w-1/3">
                        <div class="bg-gradient-to-b from-gray-50 to-white p-4 rounded-xl h-full">
                            <h4 class="font-bold text-gray-800 mb-3">اقدامات سریع</h4>
                            <div class="space-y-3">
                                <button class="w-full text-right px-4 py-2 bg-indigo-50 text-indigo-600 rounded-lg hover:bg-indigo-100 transition">
                                    <i class="fas fa-phone ml-2"></i> تماس
                                </button>
                                <button class="w-full text-right px-4 py-2 bg-green-50 text-green-600 rounded-lg hover:bg-green-100 transition">
                                    <i class="fas fa-envelope ml-2"></i> ارسال پیام
                                </button>
                                <a href="customers/edit.php?id=<?php echo $lastCustomer['id']; ?>" class="block w-full text-right px-4 py-2 bg-gray-100 text-gray-700 rounded-lg hover:bg-gray-200 transition">
                                    <i class="fas fa-edit ml-2"></i> ویرایش
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php else: ?>
            <div class="neumorphic p-8 rounded-xl text-center">
                <div class="w-20 h-20 mx-auto mb-4 bg-gradient-to-r from-gray-200 to-gray-300 rounded-full flex items-center justify-center">
                    <i class="fas fa-user-slash text-gray-500 text-3xl"></i>
                </div>
                <h3 class="text-lg font-bold text-gray-700 mb-2">مشتری‌ای ثبت نشده است</h3>
                <p class="text-gray-500 mb-4">هنوز هیچ مشتری در سیستم ثبت نشده است.</p>
                <a href="customers/add.php" class="inline-block modern-btn px-6 py-3 bg-gradient-to-r from-indigo-500 to-indigo-700 text-white rounded-xl hover:shadow-lg transition-all">
                    <i class="fas fa-plus ml-2"></i> افزودن اولین مشتری
                </a>
            </div>
            <?php endif; ?>
            
            <div class="mt-6 text-center">
                <a href="customers/list.php" class="inline-flex items-center text-indigo-600 font-medium hover:text-indigo-800 transition">
                    مشاهده همه مشتری‌ها
                    <i class="fas fa-arrow-left mr-2"></i>
                </a>
            </div>
        </div>

        <!-- آخرین تارگت -->
        <div class="glass-card rounded-2xl p-6">
            <div class="flex justify-between items-center mb-6">
                <h2 class="text-xl font-bold text-gray-900 flex items-center gap-2">
                    <i class="fas fa-bullseye text-green-500"></i>
                    آخرین تارگت
                </h2>
                <a href="targets/add.php" class="modern-btn px-4 py-2 bg-gradient-to-r from-green-500 to-green-700 text-white rounded-xl hover:shadow-lg transition-all text-sm">
                    <i class="fas fa-plus ml-1"></i> جدید
                </a>
            </div>
            
            <?php if($lastTarget): ?>
            <div class="neumorphic p-5 rounded-xl">
                <div class="flex items-center gap-3 mb-4">
                    <div class="w-12 h-12 bg-gradient-to-r from-green-400 to-emerald-500 rounded-xl flex items-center justify-center text-white">
                        <i class="fas fa-bullseye"></i>
                    </div>
                    <div class="flex-1">
                        <h3 class="font-bold text-gray-900"><?php echo $lastTarget['target_name'] ?: 'نامشخص'; ?></h3>
                        <p class="text-gray-600 text-sm"><?php echo $lastTarget['phone']; ?></p>
                    </div>
                </div>
                
                <div class="space-y-4 mt-6">
                    <div>
                        <p class="text-gray-500 text-sm mb-1">حوزه کاری</p>
                        <p class="font-medium"><?php echo $lastTarget['work_field']; ?></p>
                    </div>
                    
                    <div>
                        <p class="text-gray-500 text-sm mb-1">وضعیت</p>
                        <div class="flex items-center">
                            <?php 
                                $targetStatusColor = 'gray';
                                if($lastTarget['status'] == 'فعال') $targetStatusColor = 'green';
                                if($lastTarget['status'] == 'در حال پیگیری') $targetStatusColor = 'blue';
                                if($lastTarget['status'] == 'تمام شده') $targetStatusColor = 'purple';
                            ?>
                            <span class="px-3 py-1 rounded-full text-sm font-semibold bg-<?php echo $targetStatusColor; ?>-100 text-<?php echo $targetStatusColor; ?>-800">
                                <?php echo $lastTarget['status']; ?>
                            </span>
                            <div class="flex-1 h-2 bg-gray-200 rounded-full overflow-hidden mr-3">
                                <?php 
                                    $progressWidth = '50%';
                                    if($lastTarget['status'] == 'فعال') $progressWidth = '75%';
                                    if($lastTarget['status'] == 'در حال پیگیری') $progressWidth = '40%';
                                    if($lastTarget['status'] == 'تمام شده') $progressWidth = '100%';
                                ?>
                                <div class="h-full bg-gradient-to-r from-green-400 to-emerald-500" style="width: <?php echo $progressWidth; ?>"></div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="mt-6 pt-4 border-t border-gray-200">
                    <div class="flex justify-between">
                        <a href="targets/edit.php?id=<?php echo $lastTarget['id']; ?>" class="text-green-600 hover:text-green-800 transition">
                            <i class="fas fa-edit ml-1"></i> ویرایش
                        </a>
                        <a href="targets/view.php?id=<?php echo $lastTarget['id']; ?>" class="text-gray-700 hover:text-gray-900 transition">
                            جزئیات بیشتر <i class="fas fa-arrow-left"></i>
                        </a>
                    </div>
                </div>
            </div>
            <?php else: ?>
            <div class="neumorphic p-6 rounded-xl text-center">
                <div class="w-16 h-16 mx-auto mb-4 bg-gradient-to-r from-gray-200 to-gray-300 rounded-full flex items-center justify-center">
                    <i class="fas fa-bullseye text-gray-500 text-2xl"></i>
                </div>
                <h3 class="text-lg font-bold text-gray-700 mb-2">تارگتی ثبت نشده است</h3>
                <p class="text-gray-500">هنوز هیچ تارگتی در سیستم ثبت نشده است.</p>
            </div>
            <?php endif; ?>
            
            <div class="mt-6 text-center">
                <a href="targets/list.php" class="inline-flex items-center text-green-600 font-medium hover:text-green-800 transition">
                    مشاهده همه تارگت‌ها
                    <i class="fas fa-arrow-left mr-2"></i>
                </a>
            </div>
        </div>
    </div>

    <!-- آخرین یادداشت‌ها -->
    <div class="glass-card rounded-2xl p-6 mb-8 fade-in-up" style="animation-delay: 0.3s">
        <div class="flex justify-between items-center mb-6">
            <div>
                <h2 class="text-xl font-bold text-gray-900 flex items-center gap-2">
                    <i class="fas fa-sticky-note text-amber-500"></i>
                    آخرین یادداشت‌ها
                </h2>
                <p class="text-gray-600 text-sm mt-1">۵ یادداشت آخر ثبت شده در سیستم</p>
            </div>
            <div class="flex gap-3">
                <button class="modern-btn px-4 py-2 bg-amber-50 text-amber-600 rounded-xl hover:bg-amber-100 transition-all" onclick="refreshData('notes')">
                    <i class="fas fa-sync-alt"></i> بروزرسانی
                </button>
                <a href="notes/add.php" class="modern-btn px-4 py-2 bg-gradient-to-r from-amber-500 to-orange-500 text-white rounded-xl hover:shadow-lg transition-all">
                    <i class="fas fa-plus ml-2"></i> یادداشت جدید
                </a>
            </div>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php if($lastNotes->num_rows > 0): ?>
                <?php while($note = $lastNotes->fetch_assoc()): ?>
                <div class="neumorphic p-5 rounded-xl hover:shadow-lg transition-all">
                    <div class="flex justify-between items-start mb-3">
                        <span class="px-3 py-1 bg-amber-100 text-amber-800 rounded-full text-xs font-semibold">
                            <?php echo $note['status']; ?>
                        </span>
                        <button class="text-gray-400 hover:text-gray-600 transition" onclick="showNoteDetails(<?php echo $note['id']; ?>)">
                            <i class="fas fa-ellipsis-h"></i>
                        </button>
                    </div>
                    
                    <p class="text-gray-800 mb-4 line-clamp-3"><?php echo $note['note']; ?></p>
                    
                    <div class="flex items-center justify-between pt-3 border-t border-gray-200">
                        <div class="flex items-center text-gray-500 text-sm">
                            <i class="far fa-clock ml-1"></i>
                            <span>دقایقی پیش</span>
                        </div>
                        <button class="text-amber-600 hover:text-amber-800 transition">
                            <i class="fas fa-external-link-alt"></i>
                        </button>
                    </div>
                </div>
                <?php endwhile; ?>
            <?php else: ?>
                <div class="col-span-3 neumorphic p-8 rounded-xl text-center">
                    <div class="w-20 h-20 mx-auto mb-4 bg-gradient-to-r from-gray-200 to-gray-300 rounded-full flex items-center justify-center">
                        <i class="fas fa-sticky-note text-gray-500 text-3xl"></i>
                    </div>
                    <h3 class="text-lg font-bold text-gray-700 mb-2">یادداشتی ثبت نشده است</h3>
                    <p class="text-gray-500 mb-4">هنوز هیچ یادداشتی در سیستم ثبت نشده است.</p>
                    <a href="notes/add.php" class="inline-block modern-btn px-6 py-3 bg-gradient-to-r from-amber-500 to-orange-500 text-white rounded-xl hover:shadow-lg transition-all">
                        <i class="fas fa-plus ml-2"></i> افزودن اولین یادداشت
                    </a>
                </div>
            <?php endif; ?>
        </div>
        
        <div class="mt-6 text-center">
            <a href="notes/list.php" class="inline-flex items-center text-amber-600 font-medium hover:text-amber-800 transition">
                مشاهده همه یادداشت‌ها
                <i class="fas fa-arrow-left mr-2"></i>
            </a>
        </div>
    </div>

    <!-- نوار اقدامات سریع -->
    <div class="glass-card rounded-2xl p-6 mb-8 fade-in-up" style="animation-delay: 0.4s">
        <h2 class="text-xl font-bold text-gray-900 mb-6 flex items-center gap-2">
            <i class="fas fa-bolt text-purple-500"></i>
            اقدامات سریع
        </h2>
        
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
            <a href="customers/add.php" class="modern-btn p-4 bg-gradient-to-r from-indigo-500 to-indigo-700 text-white rounded-xl hover:shadow-xl transition-all flex flex-col items-center justify-center text-center group">
                <div class="w-12 h-12 bg-white/20 rounded-full flex items-center justify-center mb-3 group-hover:scale-110 transition-transform">
                    <i class="fas fa-user-plus text-xl"></i>
                </div>
                <span class="font-bold">مشتری جدید</span>
                <span class="text-sm opacity-90 mt-1">ثبت مشتری جدید</span>
            </a>
            
            <a href="targets/add.php" class="modern-btn p-4 bg-gradient-to-r from-green-500 to-green-700 text-white rounded-xl hover:shadow-xl transition-all flex flex-col items-center justify-center text-center group">
                <div class="w-12 h-12 bg-white/20 rounded-full flex items-center justify-center mb-3 group-hover:scale-110 transition-transform">
                    <i class="fas fa-bullseye text-xl"></i>
                </div>
                <span class="font-bold">تارگت جدید</span>
                <span class="text-sm opacity-90 mt-1">هدف جدید</span>
            </a>
            
            <a href="notes/add.php" class="modern-btn p-4 bg-gradient-to-r from-amber-500 to-orange-500 text-white rounded-xl hover:shadow-xl transition-all flex flex-col items-center justify-center text-center group">
                <div class="w-12 h-12 bg-white/20 rounded-full flex items-center justify-center mb-3 group-hover:scale-110 transition-transform">
                    <i class="fas fa-edit text-xl"></i>
                </div>
                <span class="font-bold">یادداشت جدید</span>
                <span class="text-sm opacity-90 mt-1">ثبت یادداشت</span>
            </a>
            
            <a href="export.php" class="modern-btn p-4 bg-gradient-to-r from-gray-800 to-gray-900 text-white rounded-xl hover:shadow-xl transition-all flex flex-col items-center justify-center text-center group">
                <div class="w-12 h-12 bg-white/20 rounded-full flex items-center justify-center mb-3 group-hover:scale-110 transition-transform">
                    <i class="fas fa-file-export text-xl"></i>
                </div>
                <span class="font-bold">خروجی گرفتن</span>
                <span class="text-sm opacity-90 mt-1">خروجی اطلاعات</span>
            </a>
        </div>
        
        <div class="mt-6 pt-6 border-t border-gray-200">
            <div class="flex flex-wrap gap-3 justify-center">
                <button class="modern-btn px-5 py-2 bg-white text-gray-800 rounded-xl hover:bg-gray-50 transition border border-gray-300 flex items-center">
                    <i class="fas fa-chart-bar text-green-500 ml-2"></i>
                    گزارش‌گیری
                </button>
                <button class="modern-btn px-5 py-2 bg-white text-gray-800 rounded-xl hover:bg-gray-50 transition border border-gray-300 flex items-center">
                    <i class="fas fa-search text-blue-500 ml-2"></i>
                    جستجوی پیشرفته
                </button>
                <button class="modern-btn px-5 py-2 bg-white text-gray-800 rounded-xl hover:bg-gray-50 transition border border-gray-300 flex items-center">
                    <i class="fas fa-cog text-purple-500 ml-2"></i>
                    تنظیمات
                </button>
                <button class="modern-btn px-5 py-2 bg-white text-gray-800 rounded-xl hover:bg-gray-50 transition border border-gray-300 flex items-center">
                    <i class="fas fa-question-circle text-indigo-500 ml-2"></i>
                    راهنما
                </button>
            </div>
        </div>
    </div>

    <!-- فوتور -->
    <!-- <footer class="mt-8 pt-6 border-t border-gray-300 text-center text-gray-600 text-sm">
        <p>داشبورد CRM حرفه‌ای | طراحی شده با <i class="fas fa-heart text-red-500"></i> | نسخه ۲.۱</p>
        <p class="mt-1">کلیه حقوق محفوظ است © ۱۴۰۳</p>
    </footer> -->

    <!-- اسکریپت‌های جاوااسکریپت -->
    <script>
        // بروزرسانی تاریخ و زمان
        function updateDateTime() {
            const now = new Date();
            
            // زمان
            const time = now.toLocaleTimeString('fa-IR');
            document.getElementById('time').innerText = time;
            
            // تاریخ میلادی
            const date = now.toLocaleDateString('fa-IR');
            document.getElementById('date').innerText = date;
            
            // روز هفته
            const days = ['یکشنبه', 'دوشنبه', 'سه‌شنبه', 'چهارشنبه', 'پنجشنبه', 'جمعه', 'شنبه'];
            const dayName = days[now.getDay()];
            document.getElementById('dayName').innerText = dayName;
            
            // تاریخ شمسی (ساده‌سازی شده)
            const persianDate = now.toLocaleDateString('fa-IR', {
                year: 'numeric',
                month: 'long',
                day: 'numeric'
            });
            document.getElementById('persianDate').innerText = persianDate;
        }
        
        // بروزرسانی وضعیت اتصال
        function updateConnectionStatus() {
            const status = navigator.onLine ? "سیستم آنلاین" : "سیستم آفلاین";
            const statusElement = document.getElementById('connectionStatus');
            statusElement.innerText = status;
            
            if (navigator.onLine) {
                statusElement.classList.remove('text-red-600');
                statusElement.classList.add('text-green-600');
            } else {
                statusElement.classList.remove('text-green-600');
                statusElement.classList.add('text-red-600');
            }
        }
        
        // شبیه‌سازی بروزرسانی داده‌ها
        function refreshData(type) {
            const btn = event?.target.closest('button') || event?.target;
            const originalHTML = btn.innerHTML;
            
            // نمایش حالت لودینگ
            btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
            btn.disabled = true;
            
            // شبیه‌سازی تاخیر شبکه
            setTimeout(() => {
                // بازگشت به حالت اولیه
                btn.innerHTML = originalHTML;
                btn.disabled = false;
                
                // نمایش نوتیفیکیشن
                showNotification(`داده‌های ${type} با موفقیت بروزرسانی شد`, 'success');
            }, 1500);
        }
        
        // نمایش جزئیات یادداشت (شبیه‌سازی)
        function showNoteDetails(noteId) {
            showNotification(`جزئیات یادداشت شماره ${noteId} نمایش داده شد`, 'info');
        }
        
        // نمایش نوتیفیکیشن
        function showNotification(message, type = 'info') {
            // ایجاد المان نوتیفیکیشن
            const notification = document.createElement('div');
            notification.className = `fixed top-6 left-6 z-50 px-6 py-4 rounded-xl shadow-2xl text-white transform transition-all duration-300 translate-x-0 ${
                type === 'success' ? 'bg-gradient-to-r from-green-500 to-green-700' :
                type === 'error' ? 'bg-gradient-to-r from-red-500 to-red-700' :
                type === 'warning' ? 'bg-gradient-to-r from-amber-500 to-orange-500' :
                'bg-gradient-to-r from-indigo-500 to-purple-600'
            }`;
            
            notification.innerHTML = `
                <div class="flex items-center">
                    <i class="fas fa-${
                        type === 'success' ? 'check-circle' :
                        type === 'error' ? 'exclamation-circle' :
                        type === 'warning' ? 'exclamation-triangle' : 'info-circle'
                    } ml-3 text-xl"></i>
                    <div>
                        <p class="font-bold">${type === 'success' ? 'موفقیت' : type === 'error' ? 'خطا' : type === 'warning' ? 'هشدار' : 'اطلاعیه'}</p>
                        <p>${message}</p>
                    </div>
                    <button class="mr-auto text-white hover:text-gray-200 transition" onclick="this.parentElement.parentElement.remove()">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            `;
            
            // اضافه کردن به صفحه
            document.body.appendChild(notification);
            
            // حذف خودکار پس از 5 ثانیه
            setTimeout(() => {
                if (notification.parentElement) {
                    notification.style.transform = 'translateX(-150%)';
                    setTimeout(() => {
                        if (notification.parentElement) {
                            notification.remove();
                        }
                    }, 300);
                }
            }, 5000);
        }
        
        // انیمیشن کارت‌ها هنگام اسکرول
        function animateOnScroll() {
            const elements = document.querySelectorAll('.fade-in-up');
            
            elements.forEach(element => {
                const elementTop = element.getBoundingClientRect().top;
                const windowHeight = window.innerHeight;
                
                if (elementTop < windowHeight - 100) {
                    element.style.opacity = '1';
                    element.style.transform = 'translateY(0)';
                }
            });
        }
        
        // تنظیم انیمیشن اولیه برای عناصر
        document.querySelectorAll('.fade-in-up').forEach(el => {
            el.style.opacity = '0';
            el.style.transform = 'translateY(30px)';
            el.style.transition = 'opacity 0.8s ease-out, transform 0.8s ease-out';
        });
        
        // راه‌اندازی اولیه
        document.addEventListener('DOMContentLoaded', function() {
            updateDateTime();
            updateConnectionStatus();
            
            // بروزرسانی زمان هر ثانیه
            setInterval(updateDateTime, 1000);
            
            // بروزرسانی وضعیت اتصال
            setInterval(updateConnectionStatus, 5000);
            
            // فعال‌سازی انیمیشن اسکرول
            window.addEventListener('scroll', animateOnScroll);
            animateOnScroll(); // اجرای اولیه
            
            // نمایش خوش‌آمدگویی
            setTimeout(() => {
                showNotification('داشبورد CRM با موفقیت بارگذاری شد. خوش آمدید!', 'success');
            }, 1000);
            
            // افزودن افکت به کارت‌های آماری
            const statCards = document.querySelectorAll('.stat-card');
            statCards.forEach(card => {
                card.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-10px) scale(1.02)';
                });
                
                card.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0) scale(1)';
                });
            });
        });
        
        // مدیریت حالت آفلاین/آنلاین
        window.addEventListener('online', updateConnectionStatus);
        window.addEventListener('offline', updateConnectionStatus);
    </script>
</body>
</html>