<?php
require "config/db.php";

// آمار کلی
$totalCustomers = $conn->query("SELECT COUNT(*) as total FROM customers")->fetch_assoc()['total'];
$totalTargets = $conn->query("SELECT COUNT(*) as total FROM targets")->fetch_assoc()['total'];
$totalNotes = $conn->query("SELECT COUNT(*) as total FROM notes")->fetch_assoc()['total'];

// آخرین ثبت‌ها
$lastCustomer = $conn->query("SELECT * FROM customers ORDER BY id DESC LIMIT 1")->fetch_assoc();
$lastTarget = $conn->query("SELECT * FROM targets ORDER BY id DESC LIMIT 1")->fetch_assoc();
$lastNotes = $conn->query("SELECT * FROM notes ORDER BY id DESC LIMIT 5");
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<title>داشبورد حرفه‌ای</title>
<script src="https://cdn.tailwindcss.com"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class="bg-gray-100 min-h-screen p-8 font-sans">

<!-- ساعت و تاریخ -->
<div class="flex justify-between items-center mb-8">
    <h1 class="text-4xl font-bold text-gray-800">داشبورد CRM</h1>
    <div class="text-gray-700 text-lg">
        <span id="date"></span> | <span id="time"></span>
    </div>
</div>

<script>
function updateDateTime(){
    const now = new Date();
    const date = now.toLocaleDateString('fa-IR');
    const time = now.toLocaleTimeString('fa-IR');
    document.getElementById('date').innerText = date;
    document.getElementById('time').innerText = time;
}
setInterval(updateDateTime, 1000);
updateDateTime();
</script>

<!-- کارت‌های آماری پیشرفته -->
<div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
    <a href="customers/list.php" class="bg-gradient-to-r from-indigo-500 to-indigo-700 text-white rounded-3xl shadow-2xl p-6 flex flex-col hover:scale-105 transition transform cursor-pointer relative overflow-hidden">
        <span class="text-lg font-semibold">مشتریان</span>
        <span class="text-4xl font-bold mt-2"><?= $totalCustomers ?></span>
        <span class="mt-2 opacity-70">تعداد کل مشتری‌ها</span>
        <div class="absolute -bottom-5 -left-5 w-24 h-24 bg-indigo-300 rounded-full opacity-30"></div>
    </a>

    <a href="targets/list.php" class="bg-gradient-to-r from-green-400 to-green-600 text-white rounded-3xl shadow-2xl p-6 flex flex-col hover:scale-105 transition transform cursor-pointer relative overflow-hidden">
        <span class="text-lg font-semibold">تارگت‌ها</span>
        <span class="text-4xl font-bold mt-2"><?= $totalTargets ?></span>
        <span class="mt-2 opacity-70">تعداد کل تارگت‌ها</span>
        <div class="absolute -bottom-5 -left-5 w-24 h-24 bg-green-300 rounded-full opacity-30"></div>
    </a>

    <a href="notes/list.php" class="bg-gradient-to-r from-yellow-400 to-yellow-600 text-white rounded-3xl shadow-2xl p-6 flex flex-col hover:scale-105 transition transform cursor-pointer relative overflow-hidden">
        <span class="text-lg font-semibold">یادداشت‌ها</span>
        <span class="text-4xl font-bold mt-2"><?= $totalNotes ?></span>
        <span class="mt-2 opacity-70">تعداد کل یادداشت‌ها</span>
        <div class="absolute -bottom-5 -left-5 w-24 h-24 bg-yellow-300 rounded-full opacity-30"></div>
    </a>
</div>

<!-- آخرین مشتری و تارگت -->
<div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
    <div class="bg-white shadow-2xl rounded-3xl p-6 hover:shadow-xl transition relative">
        <h2 class="text-xl font-bold mb-4">آخرین مشتری ثبت شده</h2>
        <?php if($lastCustomer): ?>
            <p><strong>نام:</strong> <?= $lastCustomer['name'] ?></p>
            <p><strong>شماره تماس:</strong> <?= $lastCustomer['phone'] ?></p>
            <p><strong>سطح:</strong> 
                <span class="<?= $lastCustomer['level']=='VIP'?'bg-yellow-400 text-yellow-900':'bg-gray-300 text-gray-900' ?> px-3 py-1 rounded-full text-sm font-semibold">
                    <?= $lastCustomer['level'] ?>
                </span>
            </p>
            <p><strong>وضعیت:</strong> <?= $lastCustomer['status'] ?></p>
        <?php else: ?>
            <p>هیچ مشتری ثبت نشده است.</p>
        <?php endif; ?>
        <a href="customers/list.php" class="mt-3 inline-block text-indigo-600 font-semibold hover:underline">نمایش همه مشتری‌ها</a>
    </div>

    <div class="bg-white shadow-2xl rounded-3xl p-6 hover:shadow-xl transition relative">
        <h2 class="text-xl font-bold mb-4">آخرین تارگت ثبت شده</h2>
        <?php if($lastTarget): ?>
            <p><strong>نام:</strong> <?= $lastTarget['target_name'] ?: "-" ?></p>
            <p><strong>شماره تماس:</strong> <?= $lastTarget['phone'] ?></p>
            <p><strong>حوزه کاری:</strong> <?= $lastTarget['work_field'] ?></p>
            <p><strong>وضعیت:</strong> <?= $lastTarget['status'] ?></p>
        <?php else: ?>
            <p>هیچ تارگتی ثبت نشده است.</p>
        <?php endif; ?>
        <a href="targets/list.php" class="mt-3 inline-block text-green-600 font-semibold hover:underline">نمایش همه تارگت‌ها</a>
    </div>
</div>

<!-- آخرین یادداشت‌ها -->
<div class="bg-white shadow-2xl rounded-3xl p-6 mb-8 hover:shadow-xl transition relative">
    <div class="flex justify-between items-center mb-4">
        <h2 class="text-xl font-bold">آخرین یادداشت‌ها</h2>
        <a href="notes/add.php" class="px-4 py-2 bg-yellow-400 text-white rounded-xl hover:bg-yellow-500 transition">+ افزودن یادداشت</a>
    </div>
    <ul class="space-y-3 max-h-48 overflow-y-auto">
        <?php if($lastNotes->num_rows > 0): ?>
            <?php while($note = $lastNotes->fetch_assoc()): ?>
                <li class="p-3 bg-gray-100 rounded-xl hover:bg-gray-200 transition shadow-inner">
                    <?= $note['note_text'] ?>
                    <span class="block mt-1 text-gray-500 text-sm"><?= $note['status'] ?></span>
                </li>
            <?php endwhile; ?>
        <?php else: ?>
            <li>هیچ یادداشتی ثبت نشده است.</li>
        <?php endif; ?>
    </ul>
</div>

<!-- نوار سریع اکشن -->
<div class="flex flex-wrap gap-4">
    <a href="customers/add.php" class="px-6 py-3 bg-gradient-to-r from-indigo-500 to-indigo-700 text-white rounded-2xl shadow hover:scale-105 transition transform font-semibold">+ مشتری جدید</a>
    <a href="targets/add.php" class="px-6 py-3 bg-gradient-to-r from-green-400 to-green-600 text-white rounded-2xl shadow hover:scale-105 transition transform font-semibold">+ تارگت جدید</a>
    <a href="notes/add.php" class="px-6 py-3 bg-gradient-to-r from-yellow-400 to-yellow-500 text-white rounded-2xl shadow hover:scale-105 transition transform font-semibold">+ یادداشت جدید</a>
    <a href="export.php" class="px-6 py-3 bg-gray-800 text-white rounded-2xl shadow hover:scale-105 transition transform font-semibold">💾 خروجی شماره‌ها</a>
</div>

</body>
</html>
