<?php
session_start();
require "config/db.php";

$error = "";

if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $username = $_POST['username'];
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT * FROM admins WHERE username=?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();
    $admin = $result->fetch_assoc();

    if($admin && password_verify($password, $admin['password'])){
        $_SESSION['admin_logged_in'] = true;
        $_SESSION['admin_username'] = $admin['username'];
        header("Location: index.php");
        exit;
    } else {
        $error = "نام کاربری یا رمز عبور اشتباه است!";
    }
}
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<title>ورود ادمین</title>
<script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen flex items-center justify-center">

<div class="bg-white p-10 rounded-3xl shadow-2xl w-full max-w-md">
    <h1 class="text-3xl font-bold mb-6 text-gray-800 text-center">ورود ادمین</h1>

    <?php if($error): ?>
        <div class="bg-red-100 text-red-700 p-3 rounded mb-4"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST" class="space-y-5">
        <input type="text" name="username" placeholder="نام کاربری" required
               class="w-full p-3 rounded-xl border border-gray-300 focus:ring-2 focus:ring-indigo-500 outline-none">
        
        <input type="password" name="password" placeholder="رمز عبور" required
               class="w-full p-3 rounded-xl border border-gray-300 focus:ring-2 focus:ring-indigo-500 outline-none">

        <button type="submit" class="w-full py-3 bg-gradient-to-r from-indigo-500 to-indigo-700 text-white rounded-xl shadow hover:scale-105 transition transform font-semibold">
            ورود
        </button>
    </form>
</div>

</body>
</html>
