<?php
require "../config/db.php";
session_start(); // شروع session

// اگر کاربر لاگین نکرده باشد
if(!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true){
    header("Location: ../login.php"); // ریدایرکت به صفحه لاگین
    exit;
}

if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $note = $_POST['note'];
    $status = $_POST['status'];

    $stmt = $conn->prepare("INSERT INTO notes (note, status) VALUES (?, ?)");
    $stmt->bind_param("ss", $note, $status);
    $stmt->execute();
    header("Location: list.php");
}
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>افزودن یادداشت</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen flex items-center justify-center">

<div class="bg-white p-8 rounded-2xl shadow-lg w-full max-w-lg">
    <h2 class="text-2xl font-bold mb-6 text-gray-800">افزودن یادداشت جدید</h2>

    <form method="POST" class="space-y-4">
        <div>
            <label class="block text-gray-700 mb-2">متن یادداشت</label>
            <textarea name="note" required class="w-full p-3 rounded-lg border border-gray-300" rows="5"></textarea>
        </div>

        <div>
            <label class="block text-gray-700 mb-2">وضعیت</label>
            <select name="status" class="w-full p-3 rounded-lg border border-gray-300">
                <option value="فعال">فعال</option>
                <option value="غیرفعال">غیرفعال</option>
            </select>
        </div>

        <button type="submit" class="w-full py-3 bg-emerald-500 text-white rounded-xl hover:bg-emerald-600 transition">
            ذخیره یادداشت
        </button>
    </form>

</div>

</body>
</html>
