<?php
require "../config/db.php";
session_start(); // شروع session

// اگر کاربر لاگین نکرده باشد
if(!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true){
    header("Location: ../login.php"); // ریدایرکت به صفحه لاگین
    exit;
}

$id = $_GET['id'];
$noteData = $conn->query("SELECT * FROM notes WHERE id=$id")->fetch_assoc();

if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $note = $_POST['note'];
    $status = $_POST['status'];

    $stmt = $conn->prepare("UPDATE notes SET note=?, status=? WHERE id=?");
    $stmt->bind_param("ssi", $note, $status, $id);
    $stmt->execute();
    header("Location: list.php");
}
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>ویرایش یادداشت</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen flex items-center justify-center">

<div class="bg-white p-8 rounded-2xl shadow-lg w-full max-w-lg">
    <h2 class="text-2xl font-bold mb-6 text-gray-800">ویرایش یادداشت</h2>

    <form method="POST" class="space-y-4">
        <div>
            <label class="block text-gray-700 mb-2">متن یادداشت</label>
            <textarea name="note" required class="w-full p-3 rounded-lg border border-gray-300" rows="5"><?= $noteData['note'] ?></textarea>
        </div>

        <div>
            <label class="block text-gray-700 mb-2">وضعیت</label>
            <select name="status" class="w-full p-3 rounded-lg border border-gray-300">
                <option value="فعال" <?= $noteData['status']=="فعال"?'selected':'' ?>>فعال</option>
                <option value="غیرفعال" <?= $noteData['status']=="غیرفعال"?'selected':'' ?>>غیرفعال</option>
            </select>
        </div>

        <button type="submit" class="w-full py-3 bg-blue-500 text-white rounded-xl hover:bg-blue-600 transition">
            ذخیره تغییرات
        </button>
    </form>

</div>

</body>
</html>
