<?php
require "../config/db.php";
session_start(); // شروع session

// اگر کاربر لاگین نکرده باشد
if(!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true){
    header("Location: ../login.php"); // ریدایرکت به صفحه لاگین
    exit;
}

$notes = $conn->query("SELECT * FROM notes ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>لیست یادداشت‌ها</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen p-10">

<h2 class="text-3xl font-bold mb-6 text-gray-800">یادداشت‌ها</h2>

<div class="flex justify-between mb-6">
    <a href="add.php" class="px-6 py-3 bg-emerald-500 text-white rounded-xl shadow hover:bg-emerald-600 transition">
        + افزودن یادداشت
    </a>
    <a href="../index.php" class="px-6 py-3 bg-gray-800 text-white rounded-xl shadow hover:bg-black transition">
        ← بازگشت به داشبورد
    </a>
</div>

<div class="bg-white rounded-xl shadow p-6">
    <table class="w-full table-auto text-right">
        <thead>
            <tr class="bg-gray-200">
                <th class="p-3 text-gray-700">شناسه</th>
                <th class="p-3 text-gray-700">متن یادداشت</th>
                <th class="p-3 text-gray-700">وضعیت</th>
                <th class="p-3 text-gray-700">تاریخ</th>
                <th class="p-3 text-gray-700">عملیات</th>
            </tr>
        </thead>
        <tbody>
            <?php while($row = $notes->fetch_assoc()): ?>
            <tr class="border-b hover:bg-gray-50 transition">
                <td class="p-3"><?= $row["id"] ?></td>
                <td class="p-3"><?= $row["note"] ?></td>
                <td class="p-3">
                    <?php if($row["status"]=="فعال"): ?>
                        <span class="px-3 py-1 bg-green-200 text-green-800 rounded-full text-sm">فعال</span>
                    <?php else: ?>
                        <span class="px-3 py-1 bg-red-200 text-red-800 rounded-full text-sm">غیرفعال</span>
                    <?php endif; ?>
                </td>
                <td class="p-3"><?= $row["created_at"] ?></td>
                <td class="p-3 flex gap-2">
                    <a href="edit.php?id=<?= $row['id'] ?>" class="px-3 py-1 bg-blue-500 text-white rounded hover:bg-blue-600 transition">ویرایش</a>
                    <a href="delete.php?id=<?= $row['id'] ?>" 
                       onclick="return confirm('آیا مطمئن هستید می‌خواهید حذف کنید؟')"
                       class="px-3 py-1 bg-red-500 text-white rounded hover:bg-red-600 transition">حذف</a>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>

</body>
</html>
