<?php
require "../config/db.php";
session_start(); // شروع session

// اگر کاربر لاگین نکرده باشد
if(!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true){
    header("Location: ../login.php"); // ریدایرکت به صفحه لاگین
    exit;
}

if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $target_name = $_POST['target_name'];
    $phone = $_POST['phone'];
    $work_field = $_POST['work_field'];
    $address = $_POST['address'];
    $description = $_POST['description'];
    $status = $_POST['status'];

    $stmt = $conn->prepare("INSERT INTO targets (target_name, phone, work_field, address, description, status) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssss", $target_name, $phone, $work_field, $address, $description, $status);
    $stmt->execute();
    header("Location: list.php");
}
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>افزودن تارگت</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen flex items-center justify-center">

<div class="bg-white p-8 rounded-2xl shadow-lg w-full max-w-lg">
    <h2 class="text-2xl font-bold mb-6 text-gray-800">افزودن تارگت جدید</h2>

    <form method="POST" class="space-y-4">
        <div>
            <label class="block text-gray-700 mb-2">نام تارگت</label>
            <input type="text" name="target_name" class="w-full p-3 rounded-lg border border-gray-300" placeholder="اختیاری">
        </div>

        <div>
            <label class="block text-gray-700 mb-2">شماره تماس</label>
            <input type="text" name="phone" required class="w-full p-3 rounded-lg border border-gray-300">
        </div>

        <div>
            <label class="block text-gray-700 mb-2">حوزه کاری</label>
            <input type="text" name="work_field" required class="w-full p-3 rounded-lg border border-gray-300">
        </div>

        <div>
            <label class="block text-gray-700 mb-2">آدرس</label>
            <input type="text" name="address" required class="w-full p-3 rounded-lg border border-gray-300">
        </div>

        <div>
            <label class="block text-gray-700 mb-2">توضیحات</label>
            <textarea name="description" class="w-full p-3 rounded-lg border border-gray-300" rows="3"></textarea>
        </div>

        <div>
            <label class="block text-gray-700 mb-2">وضعیت</label>
            <select name="status" class="w-full p-3 rounded-lg border border-gray-300">
                <option value="فعال">فعال</option>
                <option value="غیرفعال">غیرفعال</option>
            </select>
        </div>

        <button type="submit" class="w-full py-3 bg-purple-600 text-white rounded-xl hover:bg-purple-700 transition">
            ذخیره تارگت
        </button>
    </form>

</div>
</body>
</html>
