<?php
require "../config/db.php";
session_start(); // شروع session

// اگر کاربر لاگین نکرده باشد
if(!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true){
    header("Location: ../login.php"); // ریدایرکت به صفحه لاگین
    exit;
}

$id = $_GET['id'];
$targetData = $conn->query("SELECT * FROM targets WHERE id=$id")->fetch_assoc();

if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $target_name = $_POST['target_name'];
    $phone = $_POST['phone'];
    $work_field = $_POST['work_field'];
    $address = $_POST['address'];
    $description = $_POST['description'];
    $status = $_POST['status'];

    $stmt = $conn->prepare("UPDATE targets SET target_name=?, phone=?, work_field=?, address=?, description=?, status=? WHERE id=?");
    $stmt->bind_param("ssssssi", $target_name, $phone, $work_field, $address, $description, $status, $id);
    $stmt->execute();
    header("Location: list.php");
}
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>ویرایش تارگت</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen flex items-center justify-center">

<div class="bg-white p-8 rounded-2xl shadow-lg w-full max-w-lg">
    <h2 class="text-2xl font-bold mb-6 text-gray-800">ویرایش تارگت</h2>

    <form method="POST" class="space-y-4">
        <div>
            <label class="block text-gray-700 mb-2">نام تارگت</label>
            <input type="text" name="target_name" value="<?= $targetData['target_name'] ?>" class="w-full p-3 rounded-lg border border-gray-300" placeholder="اختیاری">
        </div>

        <div>
            <label class="block text-gray-700 mb-2">شماره تماس</label>
            <input type="text" name="phone" value="<?= $targetData['phone'] ?>" required class="w-full p-3 rounded-lg border border-gray-300">
        </div>

        <div>
            <label class="block text-gray-700 mb-2">حوزه کاری</label>
            <input type="text" name="work_field" value="<?= $targetData['work_field'] ?>" required class="w-full p-3 rounded-lg border border-gray-300">
        </div>

        <div>
            <label class="block text-gray-700 mb-2">آدرس</label>
            <input type="text" name="address" value="<?= $targetData['address'] ?>" required class="w-full p-3 rounded-lg border border-gray-300">
        </div>

        <div>
            <label class="block text-gray-700 mb-2">توضیحات</label>
            <textarea name="description" class="w-full p-3 rounded-lg border border-gray-300" rows="3"><?= $targetData['description'] ?></textarea>
        </div>

        <div>
            <label class="block text-gray-700 mb-2">وضعیت</label>
            <select name="status" class="w-full p-3 rounded-lg border border-gray-300">
                <option value="فعال" <?= $targetData['status']=="فعال"?'selected':'' ?>>فعال</option>
                <option value="غیرفعال" <?= $targetData['status']=="غیرفعال"?'selected':'' ?>>غیرفعال</option>
            </select>
        </div>

        <button type="submit" class="w-full py-3 bg-blue-500 text-white rounded-xl hover:bg-blue-600 transition">
            ذخیره تغییرات
        </button>
    </form>

</div>
</body>
</html>
