<?php
require "../config/db.php";
session_start(); // شروع session

// اگر کاربر لاگین نکرده باشد
if(!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true){
    header("Location: ../login.php"); // ریدایرکت به صفحه لاگین
    exit;
}

$targets = $conn->query("SELECT * FROM targets ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>لیست تارگت‌ها پیشرفته</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        /* tooltip ساده برای توضیحات */
        .tooltip {
            position: relative;
            display: inline-block;
        }

        .tooltip .tooltiptext {
            visibility: hidden;
            width: 200px;
            background-color: rgba(31, 41, 55, 0.9);
            color: #fff;
            text-align: right;
            border-radius: 8px;
            padding: 8px;
            position: absolute;
            z-index: 1;
            bottom: 120%;
            right: 0;
            opacity: 0;
            transition: opacity 0.3s;
            font-size: 0.875rem;
        }

        .tooltip:hover .tooltiptext {
            visibility: visible;
            opacity: 1;
        }
    </style>
</head>
<body class="bg-gray-100 min-h-screen p-10">

<h2 class="text-3xl font-bold mb-6 text-gray-800">تارگت‌ها</h2>

<div class="flex justify-between mb-6">
    <div class="flex gap-3">
        <a href="add.php" class="px-6 py-3 bg-purple-600 text-white rounded-xl shadow hover:bg-purple-700 transition">
            + افزودن تارگت
        </a>
        <button onclick="copyAllPhones()" class="px-6 py-3 bg-green-500 text-white rounded-xl shadow hover:bg-green-600 transition">
            📋 کپی تمام شماره‌ها
        </button>
    </div>
    <a href="../index.php" class="px-6 py-3 bg-gray-800 text-white rounded-xl shadow hover:bg-black transition">
        ← بازگشت به داشبورد
    </a>
</div>

<div class="mb-4">
    <input type="text" id="searchInput" placeholder="جستجو بر اساس نام، شماره یا توضیحات..." 
           class="w-full p-3 rounded-xl border border-gray-300 focus:outline-none focus:ring-2 focus:ring-purple-500">
</div>

<div class="bg-white rounded-2xl shadow p-6 overflow-x-auto">
    <table class="w-full table-auto text-right" id="targetsTable">
        <thead>
            <tr class="bg-gray-200">
                <th class="p-3 text-gray-700">شناسه</th>
                <th class="p-3 text-gray-700">نام تارگت</th>
                <th class="p-3 text-gray-700">شماره تماس</th>
                <th class="p-3 text-gray-700">حوزه کاری</th>
                <th class="p-3 text-gray-700">آدرس</th>
                <th class="p-3 text-gray-700">توضیحات</th>
                <th class="p-3 text-gray-700">وضعیت</th>
                <th class="p-3 text-gray-700">عملیات</th>
            </tr>
        </thead>
        <tbody>
            <?php while($row = $targets->fetch_assoc()): ?>
            <tr class="border-b hover:bg-gray-50 transition">
                <td class="p-3"><?= $row["id"] ?></td>
                <td class="p-3"><?= $row["target_name"] ?: "-" ?></td>
                <td class="p-3 flex items-center gap-2">
                    <span id="phone-<?= $row['id'] ?>"><?= $row["phone"] ?></span>
                    <button onclick="copyPhone('phone-<?= $row['id'] ?>')" 
                            class="px-2 py-1 bg-blue-500 text-white rounded hover:bg-blue-600 transition text-sm">
                        📋
                    </button>
                </td>
                <td class="p-3"><?= $row["work_field"] ?></td>
                <td class="p-3"><?= $row["address"] ?></td>
                <td class="p-3">
                    <div class="tooltip max-w-xs truncate">
                        <?= htmlspecialchars($row["description"] ?: "-") ?>
                        <span class="tooltiptext"><?= htmlspecialchars($row["description"] ?: "هیچ توضیحی ثبت نشده") ?></span>
                    </div>
                </td>
                <td class="p-3">
                    <?php if($row["status"]=="فعال"): ?>
                        <span class="px-3 py-1 bg-green-200 text-green-800 rounded-full text-sm">فعال</span>
                    <?php else: ?>
                        <span class="px-3 py-1 bg-red-200 text-red-800 rounded-full text-sm">غیرفعال</span>
                    <?php endif; ?>
                </td>
                <td class="p-3 flex gap-2">
                    <a href="edit.php?id=<?= $row['id'] ?>" class="px-3 py-1 bg-blue-500 text-white rounded hover:bg-blue-600 transition">ویرایش</a>
                    <a href="delete.php?id=<?= $row['id'] ?>" 
                       onclick="return confirm('آیا مطمئن هستید می‌خواهید حذف کنید؟')"
                       class="px-3 py-1 bg-red-500 text-white rounded hover:bg-red-600 transition">حذف</a>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>

<script>
// کپی شماره تماس تکی
function copyPhone(id){
    const phone = document.getElementById(id).innerText;
    navigator.clipboard.writeText(phone).then(() => alert("شماره کپی شد: " + phone));
}

// کپی تمام شماره‌ها
function copyAllPhones(){
    const phones = Array.from(document.querySelectorAll("span[id^='phone-']")).map(span => span.innerText).join("\n");
    navigator.clipboard.writeText(phones).then(() => alert("تمام شماره‌ها کپی شد!"));
}

// جستجوی زنده
document.getElementById("searchInput").addEventListener("input", function(){
    const filter = this.value.toLowerCase();
    const rows = document.querySelectorAll("#targetsTable tbody tr");
    rows.forEach(row => {
        const text = row.innerText.toLowerCase();
        row.style.display = text.includes(filter) ? "" : "none";
    });
});
</script>

</body>
</html>
